/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.experience.calculation.condition;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.stats.Stat;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.calculation.condition.Condition;
import net.puffish.skillsmod.api.experience.calculation.condition.ConditionFactory;
import net.puffish.skillsmod.api.json.JsonElementWrapper;
import net.puffish.skillsmod.api.json.JsonObjectWrapper;
import net.puffish.skillsmod.api.utils.JsonParseUtils;
import net.puffish.skillsmod.api.utils.Result;
import net.puffish.skillsmod.api.utils.failure.Failure;
import net.puffish.skillsmod.api.utils.failure.ManyFailures;

public class StatCondition
implements Condition<Stat<?>> {
    private final Stat<?> stat;

    private StatCondition(Stat<?> stat) {
        this.stat = stat;
    }

    public static ConditionFactory<Stat<?>> factory() {
        return ConditionFactory.withData(StatCondition::parse);
    }

    public static Result<StatCondition, Failure> parse(JsonElementWrapper rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(StatCondition::parse);
    }

    public static Result<StatCondition, Failure> parse(JsonObjectWrapper rootObject) {
        ArrayList<Failure> failures = new ArrayList<Failure>();
        Optional optStat = rootObject.get("stat").andThen(JsonParseUtils::parseStat).ifFailure(failures::add).getSuccess();
        if (failures.isEmpty()) {
            return Result.success(new StatCondition((Stat)optStat.orElseThrow()));
        }
        return Result.failure(ManyFailures.ofList(failures));
    }

    @Override
    public boolean test(Stat<?> stat) {
        return this.stat.equals(stat);
    }
}

